<?php
/***************************************************************
*  Copyright notice
*  
*  (c) 2002-2004 Kasper Skrhj (kasper@typo3.com)
*  All rights reserved
*
*  This script is part of the Typo3 project. The Typo3 project is 
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
* 
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
* 
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
/** 
 * Class that adds the wizard icon.
 *
 * $Id: class.tx_newloginbox_pi1_wizicon.php 5631 2007-06-07 20:22:09Z stradarius $
 *
 * @author	Kasper Skrhj (kasper@typo3.com)
 */
/**
 * [CLASS/FUNCTION INDEX of SCRIPT]
 *
 *
 *
 *   56: class tx_newloginbox_pi1_wizicon 
 *   64:     function proc($wizardItems)	
 *   84:     function includeLocalLang()	
 *
 * TOTAL FUNCTIONS: 2
 * (This index is automatically created/updated by the extension "extdeveval")
 *
 */





/**
 * Class that adds the wizard icon.
 * 
 * @author	Kasper Skrhj (kasper@typo3.com)
 * @package TYPO3
 * @subpackage tx_newloginbox
 */
class tx_newloginbox_pi1_wizicon {

	/**
	 * Adds the newloginbox wizard icon
	 * 
	 * @param	array		Input array with wizard items for plugins
	 * @return	array		Modified input array, having the item for newloginbox added.
	 */
	function proc($wizardItems)	{
		global $LANG;

		$LL = $this->includeLocalLang();

		$wizardItems['plugins_tx_newloginbox_pi1'] = array(
			'icon'=>t3lib_extMgm::extRelPath('newloginbox').'pi1/ce_wiz.gif',
			'title'=>$LANG->getLLL('pi1_title',$LL),
			'description'=>$LANG->getLLL('pi1_plus_wiz_description',$LL),
			'params'=>'&defVals[tt_content][CType]=list&defVals[tt_content][list_type]=newloginbox_pi1'
		);

		return $wizardItems;
	}

	/**
	 * Includes the locallang file for the 'newloginbox' extension
	 * 
	 * @return	array		The LOCAL_LANG array
	 */
	function includeLocalLang() {
        $typoVersion = t3lib_div::int_from_ver($GLOBALS['TYPO_VERSION']);

        if ($typoVersion >= 3008000) {
            $LOCAL_LANG = $GLOBALS['LANG']->includeLLFile(t3lib_extMgm::extPath('newloginbox').'locallang.xml',FALSE);
        } else {
            include(t3lib_extMgm::extPath('newloginbox').'locallang.php');
        }
        return $LOCAL_LANG;
    }
	
}



if (defined('TYPO3_MODE') && $TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/newloginbox/pi1/class.tx_newloginbox_pi1_wizicon.php'])	{
	include_once($TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/newloginbox/pi1/class.tx_newloginbox_pi1_wizicon.php']);
}
?>