<?php
/***************************************************************
*  Copyright notice
*
*  (c) 2005-2005 Franz Holzinger <kontakt@fholzinger.com>
*  All rights reserved
*
*  This script is part of the Typo3 project. The Typo3 project is
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*  A copy is found in the textfile GPL.txt and important notices to the license
*  from the author is found in LICENSE.txt distributed with these scripts.
*
*
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
/**
 * Part of the tt_products (Shopping System) extension.
 *
 * view functions
 *
 * $Id:franzholz Exp $
 *
 * @author	Franz Holzinger <kontakt@fholzinger.com>
 * @package TYPO3
 * @subpackage fh_library
 *
 *
 */


class tx_fhlibrary_view {
	/**
	 * Returns the help page with a mini guide how to setup the extension
	 * 
	 * @param	object		tslib_pibase object
	 * @param	string		path and filename of the template file
	 * 				
	 * @return	string		HTML to display the help page
	 * @access public
	 * 
	 * example:
	 * 	$content .= tx_fhlibrary_view::displayHelpPage($this->cObj->fileResource('EXT:'.TT_PRODUCTS_EXTkey.'/template/products_help.tmpl'));
	 * 	unset($this->errorMessage);
	 *
	 * @see fhlibrary_pibase::pi_displayHelpPage
	 */


	function displayHelpPage(&$pibase, $helpTemplate, $extKey, $errorMessage='', $theCode='') {
			// Get language version
		$helpTemplate_lang='';
		if ($pibase->LLkey)	{
			$helpTemplate_lang = $this->cObj->getSubpart($helpTemplate,'###TEMPLATE_'.$this->LLkey.'###');
		}
		
		$helpTemplate = $helpTemplate_lang ? $helpTemplate_lang : $this->cObj->getSubpart($helpTemplate,'###TEMPLATE_DEFAULT###');
			// Markers and substitution:
		$markerArray['###PATH###'] = t3lib_extMgm::siteRelPath($extKey);
		$markerArray['###ERROR_MESSAGE###'] = ($this->errorMessage ? '<b>'.$errorMessage.'</b><br/>' : '');
		$markerArray['###CODE###'] = $theCode;
		$rc = $pibase->cObj->substituteMarkerArray($helpTemplate,$markerArray);
		return $rc;
	}

}



if (defined('TYPO3_MODE') && $TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/fh_library/lib/class.tx_fhlibrary_view.php'])	{
	include_once($TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/fh_library/lib/class.tx_fhlibrary_view.php']);
}


?>
