<?php
/***************************************************************
*  Copyright notice
*
*  (c) 2005-2006 Kasper Skaarhoj <kasperYYYY@typo3.com>
*  All rights reserved
*
*  This script is part of the Typo3 project. The Typo3 project is
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*  A copy is found in the textfile GPL.txt and important notices to the license
*  from the author is found in LICENSE.txt distributed with these scripts.
*
*
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
/**
 * Part of the tt_products (Shopping System) extension.
 *
 * view functions
 *
 * $Id:  franzholz Exp $
 *
 * @author	Franz Holzinger <kontakt@fholzinger.com>
 * @package TYPO3
 * @subpackage fh_library
 *
 *
 */


class tx_fhlibrary_system {


	/** loadTcaAdditions($ext_keys)
	*
	* Your extension may depend on fields that are added by other
	* extensios. For reasons of performance parts of the TCA are only
	* loaded on demand. To ensure that the extended TCA is loaded for
	* the extensions you depend on or which extend your extension by
	* hooks, you shall apply this function.
	*
	* @param array     extension keys which have TCA additions to load
	*/
	function loadTcaAdditions($ext_keys){
		global $_EXTKEY, $TCA;

		//Merge all ext_keys
		if (is_array($ext_keys)) {
			for($i = 0; $i < sizeof($ext_keys); $i++)	{
				if (t3lib_extMgm::isLoaded($ext_keys[$i]))	{
					//Include the ext_table
					$_EXTKEY = $ext_keys[$i];
					include(t3lib_extMgm::extPath($ext_keys[$i]).'ext_tables.php');
				}
			}
		}
	}


	// deprecated: use loadTcaAdditions instead
	function mergeExtendingTCAs($ext_keys){
		tx_fhlibrary_system::loadTcaAdditions($ext_keys);
	}


	/**
	 * Gets information for an extension, eg. version and most-recently-edited-script
	 *
	 * @param	string		Extension key
	 * @return	array		Information array (unless an error occured)
	 */
	function getExtensionInfo($extKey)	{
		$rc = '';

		if (t3lib_extMgm::isLoaded($extKey))	{
			$path = t3lib_extMgm::extPath($extKey);
			$file = $path.'/ext_emconf.php';
			if (@is_file($file))	{
				$_EXTKEY = $extKey;
				$EM_CONF = array();
				include($file);

				$eInfo = array();
					// Info from emconf:
				$eInfo['title'] = $EM_CONF[$extKey]['title'];
				$eInfo['author'] = $EM_CONF[$extKey]['author'];
				$eInfo['author_email'] = $EM_CONF[$extKey]['author_email'];
				$eInfo['author_company'] = $EM_CONF[$extKey]['author_company'];
				$eInfo['version'] = $EM_CONF[$extKey]['version'];
				$eInfo['CGLcompliance'] = $EM_CONF[$extKey]['CGLcompliance'];
				$eInfo['CGLcompliance_note'] = $EM_CONF[$extKey]['CGLcompliance_note'];
				if (is_array($EM_CONF[$extKey]['constraints']) && is_array($EM_CONF[$extKey]['constraints']['depends']))	{
					$eInfo['TYPO3_version'] = $EM_CONF[$extKey]['constraints']['depends']['typo3'];
				} else {
					$eInfo['TYPO3_version'] = $EM_CONF[$extKey]['TYPO3_version'];
				}
				$filesHash = unserialize($EM_CONF[$extKey]['_md5_values_when_last_written']);
				$eInfo['manual'] = @is_file($path.'/doc/manual.sxw');
				$rc = $eInfo;
			} else {
				$rc = 'ERROR: No emconf.php file: '.$file;
			}
		} else {
			$rc = 'Error: Extension '.$extKey.' has not been installed. (tx_fhlibrary_system::getExtensionInfo)';
		}

		return $rc;
	}
}



if (defined('TYPO3_MODE') && $TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/fh_library/lib/class.tx_fhlibrary_system.php'])	{
	include_once($TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/fh_library/lib/class.tx_fhlibrary_system.php']);
}


?>
