<?php
/***************************************************************
*  Copyright notice
*
*  (c) 2005-2007 Franz Holzinger <kontakt@fholzinger.com>
*  All rights reserved
*
*  This script is part of the Typo3 project. The Typo3 project is
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*  A copy is found in the textfile GPL.txt and important notices to the license
*  from the author is found in LICENSE.txt distributed with these scripts.
*
*
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
/**
 * Part of the tt_products (Shopping System) extension.
 *
 * language functions
 *
 * $Id:$
 *
 * @author	Franz Holzinger <kontakt@fholzinger.com>
 * @package TYPO3
 * @subpackage fh_library
 *
 *
 */


class tx_fhlibrary_language {


	/**
	 * Loads local-language values by looking for a "locallang.php" file in the plugin class directory ($this->scriptRelPath) and if found includes it.
	 * Also locallang values set in the TypoScript property "_LOCAL_LANG" are merged onto the values found in the "locallang.php" file.
	 * Allows to add a language file name like this: 'EXT:tt_products/locallang_db.xml'
	 *
	 * @param	object		tslib_pibase object
	 * @param	string		relative path and filename of the language file
	 * @param	boolean		overwrite ... if current settings should be overwritten
	 * 
	 * @return	void
	 */
	function pi_loadLL(&$pibase,$langFileParam,$overwrite=TRUE)	{
		$langFile = ($langFileParam ? $langFile = $langFileParam : 'locallang.php');

		if ($pibase->scriptRelPath)	{
			if (substr($langFile,0,4)==='EXT:')	{
				$basePath = $langFile;
			} else {
				$basePath = t3lib_extMgm::extPath($pibase->extKey).dirname($pibase->scriptRelPath).'/'.$langFile;
			}

				// php or xml as source: In any case the charset will be that of the system language.
				// However, this function guarantees only return output for default language plus the specified language (which is different from how 3.7.0 dealt with it)
			$tempLOCAL_LANG = t3lib_div::readLLfile($basePath,$pibase->LLkey);
			if (count($pibase->LOCAL_LANG) && is_array($tempLOCAL_LANG))	{
				foreach ($pibase->LOCAL_LANG as $langKey => $tempArray)	{
					if (is_array($tempLOCAL_LANG[$langKey]))	{
						if ($overwrite)	{
							$pibase->LOCAL_LANG[$langKey] = array_merge($pibase->LOCAL_LANG[$langKey],$tempLOCAL_LANG[$langKey]);
						} else {
							$pibase->LOCAL_LANG[$langKey] = array_merge($tempLOCAL_LANG[$langKey], $pibase->LOCAL_LANG[$langKey]);
						}
					}
				}
			} else {
				$pibase->LOCAL_LANG = $tempLOCAL_LANG; 
			}
			if ($pibase->altLLkey)	{
				$tempLOCAL_LANG = t3lib_div::readLLfile($basePath,$pibase->altLLkey);

				if (count($pibase->LOCAL_LANG) && is_array($tempLOCAL_LANG))	{
					foreach ($pibase->LOCAL_LANG as $langKey => $tempArray)	{
						if (is_array($tempLOCAL_LANG[$langKey]))	{
							if ($overwrite)	{
								$pibase->LOCAL_LANG[$langKey] = array_merge($pibase->LOCAL_LANG[$langKey],$tempLOCAL_LANG[$langKey]);
							} else {
								$pibase->LOCAL_LANG[$langKey] = array_merge($tempLOCAL_LANG[$langKey],$pibase->LOCAL_LANG[$langKey]);
							}
						} 
					}
				} else {
					$pibase->LOCAL_LANG = $tempLOCAL_LANG; 
				}
			}

				// Overlaying labels from TypoScript (including fictious language keys for non-system languages!):
			if (is_array($pibase->conf['_LOCAL_LANG.']))	{
				reset($pibase->conf['_LOCAL_LANG.']);
				while(list($k,$lA)=each($pibase->conf['_LOCAL_LANG.']))	{
					if (is_array($lA))	{
						$k = substr($k,0,-1);
						foreach($lA as $llK => $llV)	{
							if (is_array($llV))	{
								foreach ($llV as $llk2 => $llV2) {
									if (is_array($llV2))	{
										foreach ($llV2 as $llk3 => $llV3) {
											if (is_array($llV3))	{
												foreach ($llV3 as $llk4 => $llV4) {
													 if (is_array($llV4))	{
													 } else {
														$pibase->LOCAL_LANG[$k][$llK.$llk2.$llk3.$llk4] = $llV4;
														if ($k != 'default')	{
															$pibase->LOCAL_LANG_charset[$k][$llK.$llk2.$llk3.$llk4] = $GLOBALS['TYPO3_CONF_VARS']['BE']['forceCharset'];	// For labels coming from the TypoScript (database) the charset is assumed to be "forceCharset" and if that is not set, assumed to be that of the individual system languages (thus no conversion)
														}													 	
													 }
												}
											} else {
												$pibase->LOCAL_LANG[$k][$llK.$llk2.$llk3] = $llV3;
												if ($k != 'default')	{
													$pibase->LOCAL_LANG_charset[$k][$llK.$llk2.$llk3] = $GLOBALS['TYPO3_CONF_VARS']['BE']['forceCharset'];	// For labels coming from the TypoScript (database) the charset is assumed to be "forceCharset" and if that is not set, assumed to be that of the individual system languages (thus no conversion)
												}
											}
										}
									} else {
										$pibase->LOCAL_LANG[$k][$llK.$llk2] = $llV2;
										if ($k != 'default')	{
											$pibase->LOCAL_LANG_charset[$k][$llK.$llk2] = $GLOBALS['TYPO3_CONF_VARS']['BE']['forceCharset'];	// For labels coming from the TypoScript (database) the charset is assumed to be "forceCharset" and if that is not set, assumed to be that of the individual system languages (thus no conversion)
										}
									}
								}
							} else	{
								$pibase->LOCAL_LANG[$k][$llK] = $llV;
								if ($k != 'default')	{
									$pibase->LOCAL_LANG_charset[$k][$llK] = $GLOBALS['TYPO3_CONF_VARS']['BE']['forceCharset'];	// For labels coming from the TypoScript (database) the charset is assumed to be "forceCharset" and if that is not set, assumed to be that of the individual system languages (thus no conversion)
								}
							}
						}
					}
				}
			}
		}

	}



	/**
	 * Split Label function for front-end applications.
	 *
	 * @param	string		Key string. Accepts the "LLL:" prefix.
	 * @return	string		Label value, if any.
	 */
	function sL($input)	{
		$restStr = trim(substr($input,4));
		$extPrfx='';
		if (!strcmp(substr($restStr,0,4),'EXT:'))	{
			$restStr = trim(substr($restStr,4));
			$extPrfx='EXT:';
		}
		$parts = explode(':',$restStr);
		return ($parts[1]);
	}
	
}



if (defined('TYPO3_MODE') && $TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/fh_library/lib/class.tx_fhlibrary_language.php'])	{
	include_once($TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/fh_library/lib/class.tx_fhlibrary_language.php']);
}


?>
