<?php
/***************************************************************
*  Copyright notice
*
*  (c) 2005 Christian Welzel (gawain@camlann.de)
*  (c) 2006 Chi Hoang <chibox@gmail.com>
*  All rights reserved
*
*  This script is part of the TYPO3 project. The TYPO3 project is
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
/**
 * Module extension (addition to function menu) 'Check for updates' for the 'ter_update_check' extension.
 *
 * @author	Christian Welzel <gawain@camlann.de>
 * @co-author Chi Hoang <chibox@gmail.com>
 */

require_once(PATH_t3lib."class.t3lib_extobjbase.php");

class tx_chlem_modfunc1 extends t3lib_extobjbase {

	function modMenu() {
	    return Array (
		"tx_ter_update_check_display_installed" => "",
		"tx_ter_update_check_display_devupd" => "",
	    );
	}

	function main() {
	    global $LANG;

	    $this->doc =& $this->pObj->doc;
	    $this->content = '';
        
	    $content = $LANG->getLL('display_shy') . ':&nbsp;&nbsp;' .
		t3lib_BEfunc::getFuncCheck(0,
		    'SET[display_shy]', 
		    $this->pObj->MOD_SETTINGS['display_shy'], 
		    '',
		    '&SET[function]=tx_chlem_modfunc1');

	    if($this->pObj->CMD[doUpdate]==1) return $this->do_update();

	    if(is_file(PATH_site.'typo3temp/extensions.xml.gz')) {
        
	    	$tmp  = $this->do_show();
            $tmp .= $LANG->getLL('display_nle').':&nbsp;&nbsp;'.
                t3lib_BEfunc::getFuncCheck(0,
                'SET[tx_ter_update_check_display_installed]',
                $this->pObj->MOD_SETTINGS['tx_ter_update_check_display_installed'], 
                '',
                '&SET[function]=tx_chlem_modfunc1');
            $tmp .= '<br/>';
            $tmp .= $LANG->getLL('display_dev').':&nbsp;&nbsp;'.
                t3lib_BEfunc::getFuncCheck(0,
                'SET[tx_ter_update_check_display_devupd]',
                $this->pObj->MOD_SETTINGS['tx_ter_update_check_display_devupd'], 
                '',
                '&SET[function]=tx_chlem_modfunc1');
		$content .= $this->pObj->doc->section($LANG->getLL('header_upd_ext'), $tmp, 0, 1);
	    }
	    $tmp  = '<input type="submit" value="'.$LANG->getLL('button_get_vers').'" '.'onclick="document.location=\'index.php?SET[function]=tx_chlem_modfunc1&CMD[doUpdate]=1\';return false;" />';

	    if(is_file(PATH_site.'typo3temp/extensions.xml.gz')) {
		    $tmp .= ' ('.$LANG->getLL('note_last_update').': '.date('Y-m-d H:i',filemtime(PATH_site.'typo3temp/extensions.xml.gz')).')';
	    }

	    $tmp .= '<br/><br/>';
	    $tmp .= $this->pObj->doc->section($LANG->getLL('header_priv_notc'), $this->pObj->privacyNotice);
	    $content .= $this->pObj->doc->section($LANG->getLL('header_vers_ret'), $tmp, 0, 1);

	    return $content;
	}

	function do_show() {
	    global $LANG;

	    list($list,)=$this->pObj->getInstalledExtensions();

	    $content = '<table border="0" cellpadding="2" cellspacing="1">'.
	        '<tr class="bgColor5"><td></td><td>'.$LANG->getLL('tab_mod_name').'</td><td>'.$LANG->getLL('tab_mod_key').
		    '</td><td>'.$LANG->getLL('tab_mod_loc_ver').'</td><td>'.$LANG->getLL('tab_mod_rem_ver').'</td>'.
		    '<td>'.$LANG->getLL('tab_mod_comment').'</td></tr>';

	    $diff = $this->pObj->MOD_SETTINGS['tx_ter_update_check_display_devupd'] ? 1 : 1000;

	    foreach($list as $extKey => $data) {
        
            $this->xmlhandler->extensionsXML = array();
              
            // Make listing query, pass query to SQL database:
           $res = $GLOBALS['TYPO3_DB']->exec_SELECTquery('*','tx_chlightem_extension','tx_chlightem_extension.extkey="'.$extKey.'"');
            
            while ($row = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res)) {
                $this->xmlhandler->extensionsXML[$row['extkey']]['extkey']=$row['extkey'];
                $this->xmlhandler->extensionsXML[$row['extkey']]['uid']=$row['uid'];
                $this->xmlhandler->extensionsXML[$row['extkey']]['downloadcounter']=$row['downloadcounter'];
                $this->xmlhandler->extensionsXML[$row['extkey']]['icon']=$row['icon'];
                $this->xmlhandler->extensionsXML[$row['extkey']]['type']=$row['type'];            
            }         
    
            foreach ($this->xmlhandler->extensionsXML as $k => $v) {
        
                $res = $GLOBALS['TYPO3_DB']->exec_SELECT_mm_query('*','tx_chlightem_extension','tx_chlightem_mm','tx_chlightem_version','AND tx_chlightem_extension.uid='.$v['uid']);
                                    
                while ($row = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res)) {                    
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['version']=$row['version'];
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['title']=$row['title'];
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['description']=$row['description'];
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['state']=$row['extstate'];
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['reviewstate']=$row['reviewstate'];
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['lastuploaddate']=$row['lastuploaddate'];
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['dependencies']=unserialize($row['dependencies']);
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['authorname']=$row['authorname'];
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['authoremail']=$row['authoremail'];
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['authorcompany']=$row['authorcompany'];
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['ownerusername']=$row['ownerusername'];
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['t3xfilemd5']=$row['t3xfilemd5'];
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['category']=$row['category'];
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['uploadcomment']=$row['uploadcomment'];              
                    $this->xmlhandler->extensionsXML[$v['extkey']]['versions'][$row['version']]['EM_CONF']['downloadcounter']=$row['downloadcounter'];                           
                }
            }       
        
        
            if(!is_array($this->xmlhandler->extensionsXML[$extKey])) continue;
    
            $versions = array_keys($this->xmlhandler->extensionsXML[$extKey][versions]);
            $lastversion = $versions[count($versions)-1];
            $comment = $this->xmlhandler->extensionsXML[$extKey][versions][$lastversion][uploadcomment];
    
            if( (t3lib_extMgm::isLoaded($extKey) || $this->pObj->MOD_SETTINGS['tx_ter_update_check_display_installed']) &&
                ($data[EM_CONF][shy] == 0 || $this->pObj->MOD_SETTINGS['display_shy']) &&
                $this->pObj->versionDifference($lastversion, $data[EM_CONF][version], $diff))
            {
            
            $imgInfo = @getImageSize($this->pObj->getExtPath($extKey,$data['type']).'/ext_icon.gif');
                if (is_array($imgInfo)) {
                    $icon = '<img src="'.$GLOBALS['BACK_PATH'].$this->pObj->typeRelPaths[$data['type']].$extKey.'/ext_icon.gif'.'" '.$imgInfo[3].' alt="" />';
                } elseif ($extInfo['_ICON']) {
                    $icon = $extInfo['_ICON'];
                } else {
                    $icon = '<img src="clear.gif" width="1" height="1" alt="" />';
                }
    
                $content .= '<tr class="bgColor4"><td>'.$icon.'</td>'.
                        '<td><a href="?CMD[importExtInfo]='.$extKey.'">'.$data[EM_CONF][title].'</a></td>'.
                    '<td>'.$extKey.'</td>'.
                        '<td align="right">'.$data[EM_CONF][version].'</td>'.
                    '<td align="right">'.$lastversion.'</td>'.
                    '<td align="left">'.nl2br($comment).'</td></tr>'."\n";
            }
	    }

	    $content .= '</table><br/>';

	    return $content;
	}

	function do_update()	{
	    global $LANG;

	    $tmp = $this->pObj->content;
	    $this->pObj->content = '';
	    $this->pObj->fetchMetaData('extensions');
	    $msg = $this->pObj->content;
	    $this->pObj->content = $tmp;

	    $tmp = '';
	    if(strpos($msg, 'Error') === false) {
	        $tmp .= $LANG->getLL('msg_succ').'<br/><br/>';
	        $tmp .= '<input type="submit" value="'.$LANG->getLL('button_show_ext').'" '.
	                'onclick="document.location=\'index.php?SET[function]=tx_chlem_modfunc1\';return false;" />';
	    } else {
	        $tmp .= $LANG->getLL('msg_fail_ter2');
	    }

	    return $this->pObj->doc->section($LANG->getLL('header_vers_ret'), $tmp, 0, 1);

	}

}

if (defined("TYPO3_MODE") && $TYPO3_CONF_VARS[TYPO3_MODE]["XCLASS"]["ext/ch_lightem/modfunc/class.tx_chlem_updatecheck.php"])	{
	include_once($TYPO3_CONF_VARS[TYPO3_MODE]["XCLASS"]["ext/ch_lightem/modfunc/class.tx_chlem_updatecheck.php"]);
}

?>
